# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_RUSSIAN} "( CD)"
LangString ReadOnly ${LANG_RUSSIAN} "(  )"
LangString MainHeaderSubText ${LANG_RUSSIAN} ",         "
LangString MainLanguageLabel ${LANG_RUSSIAN} ":"
LangString MainUsernameLabel ${LANG_RUSSIAN} " :"
LangString MainPasswordLabel ${LANG_RUSSIAN} ":"
LangString MainInstallationSizeLabel ${LANG_RUSSIAN} "   ():"
LangString MainDistroLabel ${LANG_RUSSIAN} " :"
LangString MainInstallationDriveLabel ${LANG_RUSSIAN} "  ($freeSpace  )"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_RUSSIAN} " ."
LangString MainUsernameToolTip ${LANG_RUSSIAN} ",       .$\r$\n  .$\r$\n  .$\r$\n     .$\r$\n     ."
LangString MainPasswordToolTip ${LANG_RUSSIAN} ",      .$\r$\n    ."
LangString MainInstallationSizeToolTip ${LANG_RUSSIAN} "   ?$\r$\n4 -   $\r$\n8 -  "
LangString MainInstallationDriveToolTip ${LANG_RUSSIAN} "    ?$\r$\n      5   ."
LangString Distro1ToolTip ${LANG_RUSSIAN} "Ubuntu - -."
LangString Distro2ToolTip ${LANG_RUSSIAN} "Kubuntu    KDE 3.5."
LangString Distro3ToolTip ${LANG_RUSSIAN} "Kubuntu-KDE4    KDE4."
LangString Distro4ToolTip ${LANG_RUSSIAN} "Xubuntu    ."
LangString MainDistroToolTip ${LANG_RUSSIAN} "     ?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_RUSSIAN} ",    "
LangString ErrorSpaceInUsername ${LANG_RUSSIAN} ",      ."
LangString ErrorUsernameUpperCase ${LANG_RUSSIAN} ",       ."
LangString ErrorUsernameFirstCharNotLetter ${LANG_RUSSIAN} "     ."
LangString ErrorUsernameIllegalChars ${LANG_RUSSIAN} "         ."
LangString ErrorReservedUsername ${LANG_RUSSIAN} "   , ,  ."
LangString ErrorNoPassword ${LANG_RUSSIAN} ",   ."
LangString ErrorPasswordMismatch ${LANG_RUSSIAN} "  ."
LangString ErrorSpaceInPassword ${LANG_RUSSIAN} ",     ."
LangString ErrorNoFreeSpace ${LANG_RUSSIAN} "  ."
LangString ErrorNoKernel ${LANG_RUSSIAN} "     ."
LangString ErrorBcdedit ${LANG_RUSSIAN} "    bcedit:"
LangString ErrorWubibcd ${LANG_RUSSIAN} "    wubibcd:"
LangString ErrorCD2ISO ${LANG_RUSSIAN} "    , , ,          ."
LangString ErrorDownload ${LANG_RUSSIAN} "    :"
LangString ErrorNoCD ${LANG_RUSSIAN} "    -"
LangString ErrorNoAdmin ${LANG_RUSSIAN} "      !"
LangString ErrorNoMemory ${LANG_RUSSIAN} "     ${MinMemoryMB}      !"

# INSTALLER
LangString AboutToInstall ${LANG_RUSSIAN} "   $Distro-$DistroVersion"
LangString InstallHeaderInitializing ${LANG_RUSSIAN} " $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_RUSSIAN} ", ,       "
LangString InstallHeaderUncompressWubifolder ${LANG_RUSSIAN} "  wubi..."
LangString InstallHeaderCopyIso ${LANG_RUSSIAN} "  ..."
LangString InstallHeaderDownload ${LANG_RUSSIAN} "  ,     "
LangString InstallHeaderBackupIso ${LANG_RUSSIAN} "   ..."
LangString InstallHeaderWritePreseed ${LANG_RUSSIAN} "  ..."
LangString InstallHeaderWriteUninstaller ${LANG_RUSSIAN} "  ..."
LangString InstallHeaderWriteBootLoader ${LANG_RUSSIAN} " ..."
LangString InstallGenerateVirtualDisks ${LANG_RUSSIAN} "  ..."
LangString InstallCopyFiles ${LANG_RUSSIAN} "  ..."
LangString InstallCreateFolders ${LANG_RUSSIAN} " ..."
LangString InstallRetrieveIso ${LANG_RUSSIAN} "  ..."

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_RUSSIAN} "${AppName}  "
LangString UninstallAsk ${LANG_RUSSIAN} " ?"
LangString UninstallMessageField ${LANG_RUSSIAN} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_RUSSIAN} "     ( CD ISO)."
LangString UninstallBackupHomeCheckBox ${LANG_RUSSIAN} "     (home.disk)."
LangString UninstallBackupLocationField ${LANG_RUSSIAN} "   : $BackupFolder"

# FINISH
LangString EjectRebootMsg ${LANG_RUSSIAN} ",   CD/DVD       ."
LangString RebootMsg ${LANG_RUSSIAN} "     ."

# DOWNLOADER
LangString MetadlDownloading ${LANG_RUSSIAN} "  ..."
LangString MetadlChecking ${LANG_RUSSIAN} "  ..."
LangString MetadlConnecting ${LANG_RUSSIAN} "   %s..."
LangString MetadlInitializing ${LANG_RUSSIAN} "..."
LangString MetadlChecksums ${LANG_RUSSIAN} "  ..."
LangString MetadlRetrying1 ${LANG_RUSSIAN} "   %d ()... (%d  %d)"
LangString MetadlRetrying2 ${LANG_RUSSIAN} "   %d ()..."
LangString MetadlSecond ${LANG_RUSSIAN} ""
LangString MetadlSeconds ${LANG_RUSSIAN} "()"
LangString MetadlProgress ${LANG_RUSSIAN} "%s (%d%%)  %s @ %s/s"
LangString MetadlRemaining ${LANG_RUSSIAN} " (%s )"
LangString PleaseConnect ${LANG_RUSSIAN} ",    ."

# ACCESSIBILITY
LangString MobilityAids ${LANG_RUSSIAN} "      "
LangString VisibilityAids ${LANG_RUSSIAN} "     "
LangString AccessibilityButton ${LANG_RUSSIAN} "&"
LangString AccessibilityText ${LANG_RUSSIAN} " "
LangString AccessibilitySubText ${LANG_RUSSIAN} ",    "
LangString NoAccessibility ${LANG_RUSSIAN} ""
LangString VisibilityHighContrast ${LANG_RUSSIAN} " "
LangString VisibilityMagnifier ${LANG_RUSSIAN} ""
LangString VisibilityScreenReader ${LANG_RUSSIAN} "  "
LangString VisibilityBraille ${LANG_RUSSIAN} " "
LangString MobilityKeyboardModifiers ${LANG_RUSSIAN} "-"
LangString MobilityOnScreenKeyboard ${LANG_RUSSIAN} " "

# CDBOOT
LangString CDBootTitle ${LANG_RUSSIAN} "   CD"
LangString CDBootText ${LANG_RUSSIAN} "        ,        ,       .            ,    .$\r$\n$\r$\n   CD?"

# BOOTMENU
LangString BootMenuNormal ${LANG_RUSSIAN} "    ."
LangString BootMenuSafeGraphics ${LANG_RUSSIAN} "      (    )"
LangString BootMenuACPI ${LANG_RUSSIAN} "    ACPI- (    ACPI)"
LangString BootMenuVerbose ${LANG_RUSSIAN} "    ."

# FAILURE-COMMAND
LangString FailureCommand ${LANG_RUSSIAN} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
