# Gotchas:
# $xyx, $(xyz), ${xyz} and %xyx indicate variables to be replaced at runtime, please do NOT translate variable names
# & in button labels such as accessibility denotes the quick access letter
# buttons are fixed in length, so please make sure the translated strings will fit

# MAIN PAGE
LangString UseCD ${LANG_CROATIAN} "(Use CD)"
LangString ReadOnly ${LANG_CROATIAN} "(Read Only)"
LangString MainHeaderSubText ${LANG_CROATIAN} "Molim odaberite korisniko ime i lozinku za va raun"
LangString MainLanguageLabel ${LANG_CROATIAN} "Jezik:"
LangString MainUsernameLabel ${LANG_CROATIAN} "Korisniko ime:"
LangString MainPasswordLabel ${LANG_CROATIAN} "Lozinka:"
LangString MainInstallationSizeLabel ${LANG_CROATIAN} "Instalacijska veliina (GB):"
LangString MainDistroLabel ${LANG_CROATIAN} "Desktop suelje:"
LangString MainInstallationDriveLabel ${LANG_CROATIAN} "Installation Drive ($freeSpace GB free):"

# TOOLTIPS
LangString MainLanguageToolTip ${LANG_CROATIAN} "Installation language."
LangString MainUsernameToolTip ${LANG_CROATIAN} "Please select a username for the new account.$\r$\nIt must be lower case.$\r$\nIt must not contain spaces.$\r$\nIt must contain only standard letters and numbers.$\r$\nIt cannot start by a number."
LangString MainPasswordToolTip ${LANG_CROATIAN} "Please select a password for the new account.$\r$\nIt must not contain spaces."
LangString MainInstallationSizeToolTip ${LANG_CROATIAN} "How many GB do you want to allocate?$\r$\n4GB is the bare minimum$\r$\n8GB is comfortable"
LangString MainInstallationDriveToolTip ${LANG_CROATIAN} "In which drive do you want to perform the installation?$\r$\nThis drive should have at least 5 GB free."
LangString Distro1ToolTip ${LANG_CROATIAN} "Ubuntu is the default."
LangString Distro2ToolTip ${LANG_CROATIAN} "Kubuntu uses the KDE3.5 desktop."
LangString Distro3ToolTip ${LANG_CROATIAN} "Kubuntu-KDE4 uses the KDE4 desktop."
LangString Distro4ToolTip ${LANG_CROATIAN} "Xubuntu is good for older systems."
LangString MainDistroToolTip ${LANG_CROATIAN} "What graphical environment do you want to install?$\r$\n* $(Distro1ToolTip)$\r$\n* $(Distro2ToolTip)$\r$\n* $(Distro3ToolTip)$\r$\n* $(Distro4ToolTip)"

# ERRORS
LangString ErrorNoUsername ${LANG_CROATIAN} "Molimo odaverite valjano korisniko ime"
LangString ErrorSpaceInUsername ${LANG_CROATIAN} "Molim ne koristite razmake u korisnikom imenu."
LangString ErrorUsernameUpperCase ${LANG_CROATIAN} "Molim da korisniko ime bude napisano malim slovima."
LangString ErrorUsernameFirstCharNotLetter ${LANG_CROATIAN} "Vae korisniko ime mora poeti sa slovom."
LangString ErrorUsernameIllegalChars ${LANG_CROATIAN} "Vae korisniko ime mora sadravati standardna sloba i brojke"
LangString ErrorReservedUsername ${LANG_CROATIAN} "The selected username is reserved, please selected a different one."
LangString ErrorNoPassword ${LANG_CROATIAN} "Molim unesite valjanu lozinku"
LangString ErrorPasswordMismatch ${LANG_CROATIAN} "Lozinke se ne podudaraju."
LangString ErrorSpaceInPassword ${LANG_CROATIAN} "Molim ne koristiti razmake u lozinki"
LangString ErrorNoFreeSpace ${LANG_CROATIAN} "Not enough free space."
LangString ErrorNoKernel ${LANG_CROATIAN} "Could not retrieve some essential files"
LangString ErrorBcdedit ${LANG_CROATIAN} "Error while trying to execute bcdedit:"
LangString ErrorWubibcd ${LANG_CROATIAN} "Error while trying to execute wubibcd:"
LangString ErrorCD2ISO ${LANG_CROATIAN} "Could not access the CD, please make sure other applications are not using it and try again"
LangString ErrorDownload ${LANG_CROATIAN} "Pribava je prekinuta sa grekom:"
LangString ErrorNoCD ${LANG_CROATIAN} "Could not find any appropriate CD"
LangString ErrorNoAdmin ${LANG_CROATIAN} "You must be logged in as administrator!"
LangString ErrorNoMemory ${LANG_CROATIAN} "You need at least ${MinMemoryMB}MB of memory to run the installer!"

# INSTALLER
LangString AboutToInstall ${LANG_CROATIAN} "You are about to install $Distro-$DistroVersion"
LangString InstallHeaderInitializing ${LANG_CROATIAN} "Installing $Distro-$DistroVersion"
LangString InstallSubHeader ${LANG_CROATIAN} "Molimo priekajte da se potrebite datoteke pribave i pripreme."
LangString InstallHeaderUncompressWubifolder ${LANG_CROATIAN} "Dekompresiram wubi mapu..."
LangString InstallHeaderCopyIso ${LANG_CROATIAN} "Kopiram instalacijske datoteke..."
LangString InstallHeaderDownload ${LANG_CROATIAN} "Pribavljam instalacijske datoteke, mogu nastavak"
LangString InstallHeaderBackupIso ${LANG_CROATIAN} "Spremam instalacijske datoteke..."
LangString InstallHeaderWritePreseed ${LANG_CROATIAN} "Writing configuration files..."
LangString InstallHeaderWriteUninstaller ${LANG_CROATIAN} "Pripremam deinstalaciju..."
LangString InstallHeaderWriteBootLoader ${LANG_CROATIAN} "Pripremam uitava sustava..."
LangString InstallGenerateVirtualDisks ${LANG_CROATIAN} "Kreiram virtualne diskove"
LangString InstallCopyFiles ${LANG_CROATIAN} "Kopiram instalacijske datoteke..."
LangString InstallCreateFolders ${LANG_CROATIAN} "Creating folders..."
LangString InstallRetrieveIso ${LANG_CROATIAN} "Retrieving installation files."

# UNINSTALLER
LangString UninstallAlreadyInstalled ${LANG_CROATIAN} "${AppName} is already installed"
LangString UninstallAsk ${LANG_CROATIAN} "Do you want to uninstall it?"
LangString UninstallMessageField ${LANG_CROATIAN} "$OldInstallationDrive\${DefaultInstallationDir} will be uninstalled.$\r$\nYou can backup your files if you want."
LangString UninstallBackupIsoCheckBox ${LANG_CROATIAN} "Backup downloaded files (CD ISO file)."
LangString UninstallBackupHomeCheckBox ${LANG_CROATIAN} "Backup personal documents (home.disk)."
LangString UninstallBackupLocationField ${LANG_CROATIAN} "Backup location: $BackupFolder"

# FINISH
LangString EjectRebootMsg ${LANG_CROATIAN} "Please remove any CD/DVD and reboot to complete the installation."
LangString RebootMsg ${LANG_CROATIAN} "Ponovno pokrenite sustav"

# DOWNLOADER
LangString MetadlDownloading ${LANG_CROATIAN} "Downloading installation files..."
LangString MetadlChecking ${LANG_CROATIAN} "Checking installation files..."
LangString MetadlConnecting ${LANG_CROATIAN} "Spajam se %s"
LangString MetadlInitializing ${LANG_CROATIAN} "Initializing..."
LangString MetadlChecksums ${LANG_CROATIAN} "Raunam checksum..."
LangString MetadlRetrying1 ${LANG_CROATIAN} "Pokuavam opet za %d sekundi... (%d of %d)"
LangString MetadlRetrying2 ${LANG_CROATIAN} "Pokuavam opet za %d sekundi..."
LangString MetadlSecond ${LANG_CROATIAN} "sekunda"
LangString MetadlSeconds ${LANG_CROATIAN} "sekunde"
LangString MetadlProgress ${LANG_CROATIAN} "%s (%d%%) od %s @ %s/s"
LangString MetadlRemaining ${LANG_CROATIAN} " (%s jo do kraja)"
LangString PleaseConnect ${LANG_CROATIAN} "Molim poveite se na internet."

# ACCESSIBILITY
LangString MobilityAids ${LANG_CROATIAN} "Mobility Aids"
LangString VisibilityAids ${LANG_CROATIAN} "Visibility Aids"
LangString AccessibilityButton ${LANG_CROATIAN} "&Accessibility"
LangString AccessibilityText ${LANG_CROATIAN} "Accessibility profile"
LangString AccessibilitySubText ${LANG_CROATIAN} "Please select the appropriate accessibility profile"
LangString NoAccessibility ${LANG_CROATIAN} "None"
LangString VisibilityHighContrast ${LANG_CROATIAN} "High Contrast"
LangString VisibilityMagnifier ${LANG_CROATIAN} "Magnifier"
LangString VisibilityScreenReader ${LANG_CROATIAN} "Screen Reader"
LangString VisibilityBraille ${LANG_CROATIAN} "Braille Terminal"
LangString MobilityKeyboardModifiers ${LANG_CROATIAN} "Keyboard Modifiers"
LangString MobilityOnScreenKeyboard ${LANG_CROATIAN} "On-Screen Keyboard"

# CDBOOT
LangString CDBootTitle ${LANG_CROATIAN} "Install CD booter"
LangString CDBootText ${LANG_CROATIAN} "If your machine cannot boot off the CD, this program will install a new boot menu entry to help you boot from CD. In most cases this program is not needed, and it is sufficient to reboot with the CD-Rom in the tray.$\r$\n$\r$\nDo you want to proceed and install the CD booter?"

# BOOTMENU
LangString BootMenuNormal ${LANG_CROATIAN} "Start installer in normal mode"
LangString BootMenuSafeGraphics ${LANG_CROATIAN} "Start installer in safe graphic mode (only if you have display problems)"
LangString BootMenuACPI ${LANG_CROATIAN} "Start installer with ACPI workarounds (only if you have ACPI problems)"
LangString BootMenuVerbose ${LANG_CROATIAN} "Start installer in verbose mode"

# FAILURE-COMMAND
LangString FailureCommand ${LANG_CROATIAN} "The installation failed. Logs have been saved in: $INSTDIR\installation-logs.zip.$\r$\n$\r$\nNote that in verbose mode, the logs may include the password.$\r$\n$\r$\nThe system will now reboot."
