/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is NewsFox.
 *
 * The Initial Developer of the Original Code is
 * Andy Frank <andy@andyfrank.com>.
 * Portions created by the Initial Developer are Copyright (C) 2005-2006
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *   Andrey Gromyko <andrey@gromyko.name>
 *   Ron Pruitt <wa84it@gmail.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the LGPL or the GPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

const BACKUPS = "backups";
const NUMBACKUP = 5;
var numNewFeed = 0;
var fromBackup = true;
var opmlStack = new Array();
var stackIndex = 0;

////////////////////////////////////////////////////////////////
// Export OPML
////////////////////////////////////////////////////////////////

function exportOpml()
{
  var picker = Components.classes["@mozilla.org/filepicker;1"].
    createInstance(Components.interfaces.nsIFilePicker);
  picker.init(window, "Export OPML", picker.modeSave);
  picker.appendFilter("OPML Files (*.xml, *.opml)", "*.xml;*.opml");
  picker.appendFilters(picker.filterAll);
  picker.defaultString = "newsfox.opml";
  
  var result = picker.show();
  if(result == picker.returnOK || result == picker.returnReplace)
	{
		var file = Components.classes['@mozilla.org/file/local;1'].
			createInstance(Components.interfaces.nsILocalFile);
		file.initWithPath(picker.file.path);
		if(file.exists()) file.remove(true);
		file.create(file.NORMAL_FILE_TYPE, 0666);
		expOpml(file,true);
	}
}

function expOpml(file,report)
{
	try 
	{
		var srcTemplate =  '<?xml version="1.0" encoding="UTF-8"?>';
		srcTemplate += "<opml version=\"1.0\">\n";
		srcTemplate += "<head>\n\t<title>NewsFox OPML Export</title>\n";
		var currentDate = new Date();
		srcTemplate += "\t<dateModified>" + currentDate.toString() + "</dateModified>\n";
		srcTemplate += "</head>\n";
		srcTemplate += "<body/>\n</opml>";

		var opmlDoc = new DOMParser().parseFromString(srcTemplate, "text/xml");
		var opmlBody = opmlDoc.getElementsByTagName("body")[0];

		var groupNode, feedNode, feed;
		for (var i=0; i<feedGroup.length; i++)
		{
			groupNode = opmlDoc.createElement("outline");
			groupNode.setAttribute("text",feedGroup[i].title);
			opmlBody.appendChild(groupNode);
			for (var j=0; j<feedGroup[i].list.length; j++)
			{
				feed = model.get(feedGroup[i].list[j]);
				feedNode = opmlDoc.createElement("outline");
				feedNode.setAttribute("type","rss");
				feedNode.setAttribute("text",entityDecode(feed.getDisplayName()));
				feedNode.setAttribute("xmlUrl",entityDecode(feed.url));
				feedNode.setAttribute("htmlUrl",entityDecode(feed.homepage));
				feedNode.setAttribute("NFuid",entityDecode(feed.uid));
				feedNode.setAttribute("NFdeleteOld",entityDecode(feed.deleteOld));
				feedNode.setAttribute("NFdeleteUnread",entityDecode(!feed.dontDeleteUnread));
				feedNode.setAttribute("NFautoCheck",entityDecode(feed.autoCheck));
				feedNode.setAttribute("NFstyle",entityDecode(feed.style));
				groupNode.appendChild(feedNode);
			}
		}  

		var opmlSource = new XMLSerializer().serializeToString(opmlDoc);
		opmlSource = CommonFunc.convertCharCodeFrom(opmlSource, "UTF-8");

	  var out = Components.classes['@mozilla.org/network/file-output-stream;1'].
	    createInstance(Components.interfaces.nsIFileOutputStream);
	  out.init(file, 2, 0x200, false); // open as "write only"
	  
		println(out, opmlSource);
	  out.close();

	  if (report) alert("Successfully exported OMPL.");
	} 
	catch (err) 
	{
	  if (report) alert("Export failed: " + err);
	}
}

function backupOpml()
{
	var now = new Date();
	var nowFilename = getBackupFilename(now);
	var file = getProfileDir();
	file.append(BACKUPS);
	if (!file.exists()) file.create(file.DIRECTORY_TYPE, 0750);
	file.append(nowFilename);
	if(file.exists())
		return;
	else
	{
		var backupDir = getProfileDir();
		backupDir.append(BACKUPS);
		var backupEnum = backupDir.directoryEntries;
		var dirFiles = new Array();
		var i = 0;
		while (backupEnum.hasMoreElements())
			dirFiles[i++] = backupEnum.getNext().QueryInterface(Components.interfaces.nsILocalFile);
		for (i=0; i<dirFiles.length-(NUMBACKUP-1); i++)
			dirFiles[i].remove(false);
		file.create(file.NORMAL_FILE_TYPE, 0666);
		expOpml(file,false);
	}
}

function getBackupFilename(date)
{
	var year = date.getFullYear();
	var month = date.getMonth() + 1;
	month = (month < 10 ? "0" : "") + month;
	var date1 = date.getDate();
	date1 = (date1 < 10 ? "0" : "") + date1;
	var filename = "newsfox-"+year+"-"+month+"-"+date1+".opml";
	return filename;
}

////////////////////////////////////////////////////////////////
// Import OPML
////////////////////////////////////////////////////////////////

function restoreBackup()
{
	importOpml(true);
}

function importOpml(frBackup)
{
	fromBackup = frBackup;
  var picker = Components.classes["@mozilla.org/filepicker;1"].
    createInstance(Components.interfaces.nsIFilePicker);
	if (fromBackup)
	{
		var backupDir = getProfileDir();
		backupDir.append(BACKUPS);
		picker.displayDirectory = backupDir;
	}
  picker.init(window, "Import OPML", picker.modeOpen);
  picker.appendFilter("OPML Files (*.xml, *.opml)", "*.xml;*.opml");
  picker.appendFilters(picker.filterAll);

  if(picker.show() == picker.returnOK) impOpml(picker,fromBackup);
}

function impOpml(picker,fromBackup)
{ 
	try 
	{
		loadingTooltip(true);
		if (fromBackup)
		{
  		var arttree = document.getElementById("newsfox.articleTree");
			collect = new EmptyCollection();
  		arttree.view = null;  
  		arttree.view = new ArticleTreeModel();
		  var file = getProfileDir();
		  file.append("master.xml");
			if (file.exists()) file.remove(false);
		  file = getProfileDir();
		  file.append("master_index.xml");
			if (file.exists()) file.remove(false);
		  file = getProfileDir();
		  file.append("master_group.xml");
			if (file.exists()) file.remove(false);
			model = new Model();
			feedGroup = new Array();
			fdgpidx = new Array();
			feedidx = new Array();
			catgidx = new Array();
			openidx = new Array();
			loadModels();
		}

		var fix = Components.classes['@mozilla.org/docshell/urifixup;1'].getService(Components.interfaces.nsIURIFixup);
		var url = fix.createFixupURI(picker.file.path, fix.FIXUP_FLAG_ALLOW_KEYWORD_LOOKUP);

		// Locks up browser - not sure why - same code as file.js
		//var xml = document.implementation.createDocument("","",null);
		//xml.async = false;
		//xml.load(url.spec);
      
		var req = new XMLHttpRequest();
		req.open("GET", url.spec, false);
		req.overrideMimeType("application/xml");
		req.send(null);
		var xml = req.responseXML;

    opmlStack = xml.getElementsByTagName("outline");
		numNewFeed = 0;
		stackIndex = 0;
		setTimeout(addOpmlFeed,1);  // adds new feeds and then groups
	}
	catch (err)
	{
		alert("Import failed: " + err);
	}
}

function addOpmlFeed()
{
	if (stackIndex == opmlStack.length)
	{
		addOpmlGroups();
		return;
	}
	setPmeter((100*stackIndex)/opmlStack.length);
	var kid = opmlStack[stackIndex];
	var isNew, url, j, uid;
	url = kid.getAttribute("xmlUrl");
	if (url != null)
	{
		isNew = true;
		for (j=0; j<model.size(); j++)
			if (url == model.get(j).url)
			{
				isNew = false;
				kid.setAttribute("newsfox",j);
			}
		if (isNew)
		{
			var feed = createNewFeed(model, url, false, false);
			kid.setAttribute("newsfox",model.size()-1);
			var uid = kid.getAttribute("NFuid");
			var ktext = kid.getAttribute("text");
			if (ktext != null) feed.customName = encodeString(ktext);
			var khome = kid.getAttribute("htmlUrl");
			if (khome != null) feed.homepage = khome;
			if (uid != null)
			{
				feed.deleteOld = false;
				if (kid.getAttribute("NFdeleteOld") == "true")
					feed.deleteOld = !feed.deleteOld;
				feed.dontDeleteUnread = false;
				if (kid.getAttribute("NFdeleteUnread") == "false")
					feed.dontDeleteUnread = !feed.dontDeleteUnread;
				feed.autoCheck = false;
				if (kid.getAttribute("NFautoCheck") == "true")
					feed.autoCheck = !feed.autoCheck;
				feed.style = kid.getAttribute("NFstyle");
			}
			if (fromBackup && uid != null)
			{
			// has to be unique if from an *unmodified* Newsfox file
				var uniq = true;
				for (j=0; j<model.size(); j++)
					if (uid == model.get(j).uid) uniq = false;
				if (uniq) feed.uid = feed.defaultName = uid;
			}
			numNewFeed++;
		}
	}
	stackIndex++;
	setTimeout(addOpmlFeed,1);
}

function addOpmlGroups()
{
	try
	{
		var grpkids, feedNumber, grp, num;
		var numNewGrp = 0;
		for (i=0; i<opmlStack.length; i++)
		{
			if (opmlStack[i].getAttribute("type") == "rss") continue;
			grp = new FeedGroup();
			grp.title = encodeString(opmlStack[i].getAttribute("text"));
			grpkids = opmlStack[i].getElementsByTagName("outline");
			for (j=0; j<grpkids.length; j++)
			{
				feedNumber = grpkids[j].getAttribute("newsfox");
				if (feedNumber == null) continue;
				grp.list.push(feedNumber);
			}
			isNew = true;
			for (j=0; j<feedGroup.length; j++)
				if (grp.title == feedGroup[j].title)
					if (grp.list.length == feedGroup[j].list.length)
					{
						isNew = false;
						for (var k=0; k<grp.list.length; k++)
							if (grp.list[k] != feedGroup[j].list[k]) isNew = true;
					}

			if (isNew)
			{
				num = feedGroup.length;
				feedGroup.push(grp);
				fdgpidx.push(num);
				feedidx.push(-1);
				catgidx.push(0);
				openidx.push(false);
				numNewGrp++;
			}
		}
		var feedtree = document.getElementById("newsfox.feedTree");
		var fRow = feedtree.treeBoxObject.getFirstVisibleRow();
		feedtree.view = new FeedTreeModel();
		if (fromBackup)
		{
			feedtree.view.selection.select(0);
			markFlaggedUnread(false,false);
		}
		else
		{
			feedtree.view.selection.select(-1);
    	feedtree.treeBoxObject.scrollToRow(fRow);
		}
		saveModels();
		setPmeter(0);
		loadingTooltip(false);
		if (opmlStack.length == 0)
		{
			alert("Invalid OPML file");
		}
		else
		{
		  alert("Successfully imported OPML.\n\n" + numNewFeed + " new feed(s)\n" + numNewGrp + " new group(s)");
		}
	}
	catch (err)
	{
		alert("Import failed: " + err);
	}
}
